#setwd(...)

#############################################################################################
###
### SIMULATION 3 [Deviation from balanced antigen flow] Almudevar A (2017) A Model for the Regulation of Follicular 
### Dendritic Cells Predicts Invariant Reciprocal-Time Decay of Post-Vaccine 
### Antibody Response
###
### Note: Stand-alone R code is intended to resemble pseudocode. 
### No attempt to optimize R features is made. 
###
### Written by Anthony Almudevar, Deptartment of Biostatistics and Computational Biology,
### University of Rochester
###
### June 19, 2017
###
############################################################################################

###
### Create graph labels
###

ex1 = expression(paste(italic(C)[italic(t)]))
ex2 = expression(paste(italic(E)[italic(t)]))
ex3 = expression(paste(italic(t)))
ex4 = expression(paste(italic(k)[italic(t)]))
ex5 = expression(paste(italic(F)[italic(t)],'/',italic(R),sep=''))

ex6 = 'Autoregressive Deviation'
ex7 = 'Sine Wave Deviation'
ex8 = 'Finite Antigen Leak'

title.list = list(ex6,ex7,ex8)

tenm8 = expression(10^{-8})
tenm7 = expression(10^{-7})
tenm6 = expression(10^{-6})
tenm5 = expression(10^{-5})
tenm4 = expression(10^{-4})
tenm3 = expression(10^{-3})
tenm2 = expression(10^{-2})
tenm1 = expression(10^{-1})
ten0 = expression(1)
tenp1 = expression(10^{1})
tenp2 = expression(10^{2})
tenp3 = expression(10^{3})

###
### Set graphics parameters
###

pdf('pldfig-sim3.pdf')
layout.mat = matrix(1:12,4,3)
my.lwd=1.0
cex.text = 0.7
par(mfrow=c(4,3),oma=c(2,2,1.0,2),mar=c(3.5,5,1.5,2),cex.lab=0.65,cex.axis=0.7,cex.main=0.85)
layout(layout.mat)

###
### Model loop
###

for (i.count in 1:3) {
  
  ###
  ### Set random number generator seed. Use May 22, 2017 as seed
  ###

  set.seed(05222017)
  
  ###
  ### Model parameters
  ###
  
  ex0 = 25000000
  cx0 = 1000
  fx0 = 0
  alpha = 1000
  delt = 0.0001
  c.rate = function(b1,c1,f1) {-1*((25000000 + b1 - f1)/c1)*exp(-1*0.001*(25000000 + b1 - f1)/c1) }
  n = 2500000*4
  fx = numeric(n)
  cx = numeric(n)
  bx = numeric(n)
  ex = numeric(n)
  ex[1] = ex0
  fx[1] = 0
  cx[1] = cx0
  bx[1] = 0

  ###
  ### Case paths - run models in time
  ###
  
  if (i.count==1) {
    rho = 0.99999
    rv = rnorm(1)/sqrt(1-rho^2)
    for (i in 2:n) {
      delc = cx[i-1]*c.rate(bx[i-1],cx[i-1],fx[i-1])
      delf = alpha*(cx[i-1] + (i-1)*delt*delc) 
      fx[i] = fx[i-1]+delf*delt 
      cx[i] = cx[i-1]+delc*delt
      rv = rv*rho + rnorm(1)
      bx[i] = (25000000-fx[i])*rv*sqrt(1-rho^2)/8
    }
  }
  if (i.count==2) {
    for (i in 2:n) {
      delc = cx[i-1]*c.rate(bx[i-1],cx[i-1],fx[i-1])
      delf = alpha*(cx[i-1] + (i-1)*delt*delc) 
      fx[i] = fx[i-1]+delf*delt 
      cx[i] = cx[i-1]+delc*delt
      bx[i] = (25000000-fx[i])*sin(2*pi*delt*i/100)/2 
    }
  }
  if (i.count==3) {
    for (i in 2:n) {
      delc = cx[i-1]*c.rate(bx[i-1],cx[i-1],fx[i-1])
      delf = alpha*(cx[i-1] + (i-1)*delt*delc) 
      fx[i] = fx[i-1]+delf*delt 
      cx[i] = cx[i-1]+delc*delt
      bx[i] = bx[i-1] - (0.1/1.644634)*ex0/(i^2)
    }
  }
  
  ###
  ### Create graphs
  ###
  
  ind = ceiling(seq(1,n,length.out=50000))

  ex = (25000000 + bx - fx)
  
  rng = range(c(0.001,cx/cx0,ex/ex0))
  plot(delt*ind,cx[ind]/cx0,type='l',lty=5,lwd=my.lwd,col='black',log='y',ylim=rng,xlab='',ylab='',axes=F)
  lines(delt*ind,ex[ind]/ex0,type='l',lty=1,lwd=my.lwd,col='black')
  axis(1,at=seq(0,1000,250))
  axis(2,at=10^(-8:0),labels=c(tenm8,NA,tenm6,NA,tenm4,tenm3,tenm2,tenm1,ten0))
  mtext(ex3,side=1,line=2.25,cex=cex.text)
  mtext('Concentration',side=2,line=2.5,cex=cex.text)
  if (i.count==3) legend('topright',legend=c(ex1,ex2),lty=c(5,1),lwd=my.lwd,cex=0.65)
  title(title.list[[i.count]],line=0.9)

  rng = range(c(0.001,cx/cx0,ex/ex0))
  plot(delt*ind,cx[ind]/cx0,type='l',lty=5,lwd=my.lwd,col='black',log='xy',ylim=rng,xlab='',ylab='',axes=F)
  lines(delt*ind,ex[ind]/ex0,type='l',lty=1,lwd=my.lwd,col='black')
  xn = c(1,n)*delt
  for (j in seq(-20,20,0.5)) {lines(xn,10^j/xn^(1),type='l',col='gray',lwd=0.5)}
  axis(1,at=10^(-5:3),labels=c(NA,NA,tenm3,NA,tenm1,NA,tenp1,NA,tenp3))
  axis(2,at=10^(-8:0),labels=c(tenm8,NA,tenm6,NA,tenm4,tenm3,tenm2,tenm1,ten0))
  mtext(ex3,side=1,line=2.25,cex=cex.text)
  mtext('Concentration',side=2,line=2.5,cex=cex.text)

  knum = diff(log(cx))/diff(log(delt*(1:n)))
  knum = c(knum[1],knum)
  plot(delt*ind,knum[ind],type='l',ylim=c(min(-1.25,knum),0),log='',col='black',lty=1,lwd=my.lwd,xlab='',ylab='',axes=F)
  abline(h=-1,col='gray',lty=2,lwd=2)
  axis(1,at=seq(0,1000,250))
  axis(2)
  mtext(ex3,side=1,line=2.5,cex=cex.text)
  mtext(ex4,side=2,line=2.5,cex=cex.text)

  rng = c(0,1.1)
  plot(delt*ind,(fx[ind])/ex0,type='l',lty=1,lwd=my.lwd,col='black',log='',ylim=rng,xlab='',ylab='',axes=F)
  axis(1,at=seq(0,1000,250))
  axis(2,at=seq(0,1,1/4),labels = c('0','1/4','1/2','3/4','1'))
  mtext(ex3,side=1,line=2.25,cex=cex.text)
  mtext(ex5,side=2,line=2.5,cex=cex.text)
  abline(h=1,col='gray',lty=2,lwd=2)
}
dev.off()


