### 
### Example KM curve for Carlos
###
### 24 Sept 2008
### Brent Johnson

n <- 150
gs <- rbinom(n,size=1,prob=0.4) # Gleason score
y <- gs + rnorm(n)
C <- runif(n,0,6)
U <- apply(cbind(y,C),1,min) # survival time
delta <- as.numeric(y <= C) # failure indicator

library(survival)

#
# 1. Assume that strata are given in the data ...
#
par(mfrow=c(1,2))
ft1 <- survfit(Surv(U,delta) ~ strata(gs))
plot(ft1)
title(ylab="P(T > t)")
title(xlab="Time")
title(main="KM Curve - One")

#
# 2. Or, for continuous predictors, you must create your own strata
#
x <- rnorm(n)
y <- x + rnorm(n)
C <- runif(n,0,6)
U <- apply(cbind(y,C),1,min) # survival time
delta <- as.numeric(y <= C) # failure indicator
ft.weib <- survreg(Surv(exp(U),delta) ~ x) # parametric model for survival
mu.hat <- predict(ft.weib) # fitted values
S <- mu.hat <= median(mu.hat)
ft2 <- survfit(Surv(U,delta) ~ strata(S))
plot(ft2)
title(ylab="P(T > t)")
title(xlab="Time")
title(main="KM Curve - Two")

