
source("/Users/brentjohnson/Documents/Consulting/CarlosMoreno/Rprogs/PackagedProgramsForCarlos/logrank.R")

tmpcox.fun <- function(J,time,cens,x) {
	x1 <- x[,J]
	# 1. score from PH regression
	m <- coxph(Surv(time,cens)~x1)
	out <- m$score
	# 2. or, score from my program
	#ft1 <- logrank(time,cens,as.numeric(x1))
	#out <- ft1$Q
	c(J,out)
	}

cox.scores <- function(x,U,status) {
	mycol <- ncol(x)
	out <- matrix(unlist(lapply(1:mycol,tmpcox.fun,U,status,x)),mycol,2,byrow=TRUE)
	}
	
# top.coxscores returns the subset with the most significant D columns
# INPUT : 
# 	out = output from cox.scores
# 	D = number of variables
#
# OUTPUT :
#	D-by-1 logical vector
#
top.coxscores <- function(D=30,out) {
	ordout <- order(out[,2])
	N <- nrow(out)
	if(D>N) stop("D is greater than the number of input rows")
	topind <- ordout[(N-D+1):N]
	tmp <- rep(FALSE,N)
	tmp[topind] <- TRUE
	tmp
	}
	