# calculate logrank statistic and p-value
# 
# Brent Johnson
# 26 Sept 2008

tmp.lr.fun <- function(J,uet,ar,fail,y,delta,S1) {
	Tj <- uet[J]
	index <- S1==1
	y1 <- sum(ifelse(index&(y>=Tj),1,0))
	y2 <- sum(ifelse((!index)&(y>=Tj),1,0))
	d1 <- sum(ifelse(S1&(y==Tj)&(delta==1),1,0))
	e1 <- fail[J]*y1/ar[J]
	v1 <- fail[J]*(y1*y2/(ar[J]^2))*((ar[J]-fail[J])/(max(1,ar[J]-1)))
	c(d1,e1,v1)
	}
logrank <- function(y,delta,S) {
	if(!any(search()=="package:survival"))
    stop("logrank:  The 'survival' package is not loaded.")

	ft <- survfit(Surv(y,delta)~1)
	S1 <- as.numeric(S==S[1])
	UET <- ft$time
	AR <- ft$n.risk
	FAIL <- ft$n.event
	L <- length(UET)
	tmp <- matrix(unlist(lapply(1:L,tmp.lr.fun,UET,AR,FAIL,y,delta,S1)),L,3,byrow=TRUE)
	
	Q <- (sum(tmp[,1]-tmp[,2]))^2/sum(tmp[,3])
	pval <- 1-pchisq(Q,df=1,ncp=0,lower.tail=TRUE)
	list(Q=Q,p=pval,tmp=tmp)
	
	}
	
