

source("/Users/brentjohnson/Documents/Research/VariableSelection/RankAFTLasso/Rprogs/algorithms/gehan_lasso.R")
#source("gehan_lasso.R")

library(quantreg)
library(survival)

# simulate data
# -------------
n <- 100
beta <- c(3/2,3,0,0,2,0,0,0) # d=8
d <- length(beta)
x <- matrix(rnorm(n*d),n,d)
y <- x %*% beta + 2 * rnorm(n)
U <- runif(n,0,6)
Z <- apply(cbind(y,U),1,min)
delta <- as.numeric(y <= U)

# do variable selection on reduced subset
# ----------------------------------------
#lamvec <- seq(0,0.1,length=9)
lamvec <- seq(0,0.05,length=15)
cv.out <- cv.gehan.lasso(x,Z,delta,lamvec,V=5,CENTER=TRUE)
lam.opt <- cv.out$mcv
ft <- gehan.lasso(x,Z,delta,lambda=lam.opt,CENTER=TRUE)

print(cv.out$out)
print(round(ft$b,3))
