### Program to Calculate the regression parameters from discrete hazard model
###
###
Discrete.Hazard <- function(time,status,X=NULL,event.times=NULL) {
	if(is.null(event.times)) event.times <- sort(unique(time[as.logical(status)]))
	K <- length(event.times)
	ti <- 1:(K-1)

	if(!is.null(X)) {
		p <- ncol(X)

		rfun <- function(j,U,D,X,et) {
			Tj <- et[j]
			tmp.Y <- as.numeric(U == Tj & D == 1)
			a.r <- as.logical(U >= Tj)
			sar <- sum(a.r)
			if(sar < 2) out <- matrix(c(tmp.Y[a.r],j,X[a.r,]),ncol=1)
			else out <- rbind(tmp.Y[a.r],rep(j,sum(a.r)),t(X[a.r,]))
			out
			}
	
		tmp.dat <- matrix(unlist(lapply(ti,rfun,time,status,X,event.times)),
			ncol=p+2,byrow=T)
		fX.i <- matrix(unlist(
			lapply(ti,FUN=function(i,x) as.numeric(x==i),tmp.dat[,2])),
			nrow=nrow(tmp.dat))
		fX.X <- tmp.dat[,3:(p+2)]
		fX <- cbind(fX.i,fX.X)
		fY <- tmp.dat[,1]
		}
	else {
		rfun <- function(j,U,D,et) {
			Tj <- et[j]
			tmp.Y <- as.numeric(U == Tj & D == 1)
			a.r <- as.logical(U >= Tj)
			sar <- sum(a.r)
			if(sar < 2) out <- t(c(tmp.Y[a.r],j))
			else out <- rbind(tmp.Y[a.r],rep(j,sum(a.r)))
			out
			}
		tmp.dat <- matrix(unlist(lapply(ti,rfun,time,status,event.times)),
			ncol=2,byrow=T)
		fX <- matrix(unlist(
			lapply(ti,FUN=function(i,x) as.numeric(x==i),tmp.dat[,2])),
			nrow=nrow(tmp.dat))
		fY <- tmp.dat[,1]
		}

	tmp <- glm.fit(x=fX,y=fY,family=binomial(link=logit))
	tmp.V <- summary.glm(tmp)$cov.unscaled
	list(beta=as.numeric(tmp$coef),var=tmp.V)
	}
