# An R copy of Estimate_Parms.SSC

Estimate.Parms <- function(Y,U,Delta,X=NULL,L,alpha,beta=0,abvar,data=sys.parent()) {
	Y <- as.vector(Y)
	U <- as.vector(U)
	Delta <- as.vector(as.numeric(Delta))
	
	N <- length(Y)
	K <- length(L)
	
	if(is.null(X)) {
		p <- as.integer(0)
	}
	else {
		X <- as.matrix(X)
		p <- ncol(X)
	}
	

	# Initialize matrices, arrays
	wt.mat <- matrix(NA,nrow=N,ncol=K)
	a.12 <- array(NA,c(N,K,K-1+p))
	b.11 <- array(NA,c(N,K,K))

	# Create matrix of alpha_j + beta^t x_i
	if(is.null(X)) abmat <- matrix(alpha,nrow=N,ncol=K-1,byrow=T)
	else {
		xb <- X %*% beta
		abmat <- outer(as.vector(xb),alpha,FUN="+")
		}
	
	log.lam <- - log(1 + exp(-abmat))	# N x (k-1) matrix of log(lambda)
	lambda <- exp(log.lam)		# N x (k-1) matrix of lambda
	log.om <- log(1-lambda)		# N x (k-1) matrix of log(1-lambda)

	slom <- matrix(unlist(lapply(1:N,FUN=function(i,x) cumsum(x[i,]),log.om)),N,K-1,T)
	log.fhat.m <- cbind(log.lam,rep(0,N)) + cbind(rep(0,N),slom) # N-by-k
	
	next.ftn <- function(i,mytime,C.T)	 {	# similar to next.ftn in Sim.Data()
		K <- length(C.T)			# --- returns row vector of length K
		flag <- C.T >= mytime[i]	# change on 2/9/2012
									#	this reflects the position that if a patient was censored 
									# 	after the last completion time, then we set their completion time 
									#	to the max (completion time)
		if(sum(flag)==0) {
			tmp.ct <- max(C.T)
		}
		else {
			tmp.ct <- min(C.T[flag])
		}
		
		tmp.j <- match(tmp.ct,C.T)
		c(match(C.T,tmp.ct,0),rep(0,tmp.j-1),rep(1,K-tmp.j+1),tmp.j)
		} 
	next.all <- matrix(unlist(lapply(1:N,next.ftn,U,L)),N,(2*K)+1,byrow=TRUE)
	#print(next.all[1:25,])
	next.1 <- next.all[,1:K]						# match(next.j,C.T,0)
	#cat("next.1 is ",dim(next.1),"\n")
	next.2 <- next.all[,(K+1):(2*K)]				# ones >= next.j
	#cat("next.2 is ",dim(next.2),"\n")
	next.j <- next.all[,(2*K)+1]					# for error checking
	#cat("next.j is ",length(next.j),"\n")
	#cat("Delta is ",length(Delta),"\n")
	#next.Del <- (Delta * next.1) + (1-Delta) * next.2
	
	DeltaK <- matrix(Delta,N,K,byrow=FALSE)
	
	next.Del <- DeltaK * next.1 + (1-DeltaK) * next.2	# next.Del is N-by-K
	#cat("complete next.Delta\n")
	wt <- apply((DeltaK * exp(log.fhat.m) + 
		(1-DeltaK) * cbind(rep(1,N),exp(slom))) * next.1,1,sum)
	#cat("dim(wt) = ",dim(wt),"\n")
	#write(t(cbind(1:N,U,Delta,wt*next.Del)),
	#	file="/Users/brentjohnson/Dropbox/LiJohnson/tests/weights_from_R.txt",ncolumns=7)
	wt.mat <- 1/wt * next.Del
	mu.num <- apply(as.vector(Y) * wt.mat,2,sum)
	mu.den <- apply(wt.mat,2,sum)
	mu.hat <- mu.num/mu.den
	#print(round(mu.hat,3))

	##### Asymptotic Variance Estimate #####
	resid <- outer(Y,-1 * mu.hat,"+") 		# resid is N x K
	#cat("dim(resid) = ",dim(resid),"\n")
	#cat("dim(wt.mat) = ",dim(wt.mat),"\n")
	res.wt <- resid * wt.mat			# res.wt is N x K
	grad.a <- -(Delta * next.1[,-K] * (1-lambda)) + ((1-next.2[,-K]) * lambda) 	# N x (K-1)
#	cat("dim of grad.a = ",dim(grad.a),"\n")

#	if(any(next.j == 4 & Delta==0)) {
#		good <- next.j ==4 & Delta==0
#		print(cbind(Delta[good],next.j[good],grad.a[good,]))
#		}
	if(is.null(X)) grad.ab <- grad.a
	else grad.ab <- cbind(grad.a,apply(grad.a,1,sum) * X)		# N x (K-1+p)
#	cat("dim of res.wt = ",dim(res.wt),"\n")
#	cat("dim of grad.ab = ",dim(grad.ab),"\n")
	A.12 <- (t(res.wt) %*% grad.ab)/N					# K x (K-1+p)
#	cat("dim of A.12 = ",dim(A.12),"\n")
#	cat("dim of abvar = ",dim(abvar),"\n")
	
#	cat("A.12\n")
#	print(round(A.12,3))

	B.11 <- (t(res.wt) %*% res.wt)/N		# B.11 is K x K
	var.hat <- (B.11 - (A.12 %*% abvar %*% t(A.12)))/N
	list(mu=mu.hat,var=var.hat)
	}
