#
# Brent Johnson
# 26 Feb 2008
#
#
# INPUT :
# 		x = n-by-p matrix
#		y = n-by-1 vector
#		delta = n-by-1 vector
#		bound = regularization parameter, between 0 and 1
# 		b0 = initial value
#

penbj <- function(x,y,delta,bound,b0=NULL,MAX.ITER=20,TOL=1E-8) {
	
	if(!any(search()=="package:survival"))
    stop("penbj:  The 'survival' package is not loaded.")

	if(!any(search()=="package:lasso2"))
    stop("penbj:  The 'lasso2' package is not loaded.")

	iter <- 0
	absdiff <- 10
	if(is.null(b0)) bnew <- as.vector(init.Gehan(x,y,delta))
	else bnew <- as.vector(b0)
	
	while ((iter<MAX.ITER)&&(absdiff>TOL)) {
		iter <- iter + 1
		bold <- bnew
		tmpy <- impute(bold,y,delta,x)
		ytil <- tmpy - mean(tmpy)
		bnew <- as.vector(bajlocal.l1ce(ytil,x,bold,bound)$coef)
		absdiff <- max(abs(bnew-bold))
	}
	
	invisible(list(b=bnew,ytil=ytil))
}

###
###
### The following is adapted from Jin et al. (2003)
###
###

init.Gehan <- function(x,y,delta) {
  	dimnum <- dim(x) 
  	n <- dimnum[1]
  	p <- dimnum[2]
  	ynew <- 1000*(n)^2
  	yy0 <- rep(y,rep(n,n))
  	delta1 <- rep(delta,rep(n,n))
 	yy1 <- rep(y,n)
  	yy <- delta1*(yy0-yy1)
  	xx0 <- matrix(rep(as.vector(x),rep(n,n*p)),nrow=n*n)
  	xx1 <- t(matrix(rep(as.vector(t(x)),n),nrow=p))
  	xx <- xx0-xx1   
  	xxdif <- xx*delta1 
  	xsum <- apply(xxdif,2,sum)
  	xnew <- rbind(xxdif,-xsum)
  	yynew <- c(yy,ynew)
  	fitG <- rq.fit.fnb(xnew,yynew,tau=0.5)
  	fitG$coef
	}

###
###
### The following is adapted from Berwin Turlach's lasso2()
###
###
	
bajlocal.l1ce <- function(Y,X,init,bound=0.5) {
    trace <- as.logical(FALSE)
    absolute.t <- as.logical(FALSE)
    guess.constrained.coefficients <- as.vector(init)
    #guess.constrained.coefficients <- lsfit(x,y,intercept=FALSE)$coef

    X.to.C <- X
    Y.to.C <- Y
    n <- nrow(X.to.C)
    p <- ncol(X.to.C)
    if (!absolute.t) {
        rnk <- (X.to.C.qr <- qr(X.to.C))$rank
        if (rnk != p && p < n) 
            warning("X Matrix (transformed variables) has rank ", 
                rnk, " < p = ", p, ", i.e., is deficient")
        else if (rnk == 0) 
            stop("Matrix built from transformed variables is null matrix")
        t0 <- sum(abs(qr.coef(X.to.C.qr, Y.to.C))[1:rnk])
        if (any(bound > 1)) 
            stop("'bound'(s) must be between 0 and 1 if 'absolute.t' is false")
        bound <- (relative.bound <- bound) * t0
    }
    if (any(bound < 0)) 
        stop("'bound'(s) must be non negative")
    if (length(guess.constrained.coefficients) != p) 
        stop("invalid argument for 'guess.constrained.coefficients'")
    keep <- c("coefficients", "fitted.values", "residuals", "success", 
        "Lagrangian", "bound")
    if (1 == (num.bound <- length(bound))) {
        fit <- .C("lasso", X = as.double(X.to.C), n = n, p = p, 
            bound = as.double(bound), coefficients = as.double(guess.constrained.coefficients), 
            Y = as.double(Y.to.C), fitted.values = double(n), 
            residuals = double(n), Lagrangian = double(1), success = integer(1), 
            trace = trace, assub = FALSE, PACKAGE = "lasso2")[keep]
	}
	fit
}

# NOTES :
# Step 1. update R() to current version
# Step 2. rm impute.so impute.o 
# Step 3. from the unix command line, type
#	> R CMD SHLIB impute.c


impute <- function(b,y,del,x)
{
	if(!is.loaded("impute")) dyn.load("/Users/brentjohnson/Documents/Research/VariableSelection/PenLSCens/Results/impute.so")
	n <- length(y)
	mu <- as.vector(x %*% b)
	ei <- y - mu
	
	#ystar <- as.numeric(n)
	ftei <- survfit(Surv(ei,del) ~ 1,se.fit=F)
	Surv <- ftei$surv
	UniqRes <- ftei$time
	nuniq <- length(UniqRes)
	
	out <- .C("impute",
		ystar=double(n),
		as.integer(n),
		as.double(ei),
		as.double(del),
		as.double(mu),
		as.double(Surv),
		as.double(UniqRes),
		as.integer(nuniq))
	#yhat <- out[[1]]
	yhat <- out[["ystar"]]
	invisible(yhat)
}

