#
# Test Buckley-James lasso
#
# Brent Johnson
#
#
source("/Users/brentjohnson/Documents/Research/VariableSelection/PenLSCens/algorithm/PenBJ.R")

library(quantreg)
library(survival)
library(lasso2)

n <- 50
beta <- c(3,3/2,0,0,2,0,0,0)
d <- length(beta)
x <- matrix(rnorm(n*d),n,d)
y <- x %*% beta + rnorm(n,0,1)
Cens <- runif(n,0,6)
logU <- apply(cbind(y,Cens),1,min)
Delta <- as.numeric(y <= Cens)


bndvec <- seq(0.05,1,length=10)
L <- length(bndvec)
bmat <- matrix(0,L,d)
for (I in 1:L) {
	ft.bjl1 <- penbj(x,logU,Delta,bndvec[I],b0=NULL,MAX.ITER=1,TOL=1E-4)
	bmat[I,] <- as.vector(ft.bjl1$b)
	}
bmat[1,] <- rep(0,d)

matplot(bmat,type="b")

